const Service = require('node-windows').Service;
const path = require('path');
const readline = require('readline');

const serviceName = 'WE-LocalCloudService-JBGM-CLOUD';
const serviceDescription = 'WE Filecloud local Service for jbgm-cloud.de';
const serviceScript = path.join(__dirname, 'index.js');

const svc = new Service({
  name: serviceName,
  description: serviceDescription,
  script: serviceScript,
});

const rl = readline.createInterface({
  input: process.stdin,
  output: process.stdout,
});

// Überprüfen, ob der Service bereits installiert ist
const isInstalled = svc.exists;

if (isInstalled) {
    rl.question('Der Service ('+svc.id+') ist bereits installiert. Neu starten (s), beenden (b), installieren (i) oder deinstallieren (d)?', (answer) => {
        if (answer.toLowerCase() === 's') {
          svc.restart();
          console.log('Der Service wurde neu gestartet.');
        } else if (answer.toLowerCase() === 'b') {
          svc.stop();
          console.log('Der Service wurde beendet.');
        } else if (answer.toLowerCase() === 'i') {
          svc.install();
          console.log('Der Service wurde installiert.');
        } else if (answer.toLowerCase() === 'd') {
          svc.uninstall();
          console.log('Der Service wurde deinstalliert.');
        }
        rl.close();
    });
} else {
  svc.on('install', () => {
    svc.start();
  });

  rl.question('Der Service ('+svc.id+') ist nicht installiert. Installieren? (Ja/Nein)?', (answer) => {
      if (answer.toLowerCase() === 'ja' || answer.toLowerCase() === 'j') {
        svc.install();
        console.log('Der Service wurde installiert und wird gestartet.');
      } else {
        console.log('Der Service wurde nicht installiert.');
      }
      rl.close();
  });
}